<?php
if (!defined('MY_PLUGIN_DIR')) {
    define('MY_PLUGIN_DIR', plugin_dir_path(__DIR__)); // Adjust to the parent directory of includes
}

// Include the functions file
require_once MY_PLUGIN_DIR . 'functions.php';

if (!class_exists('Gang_Sheet_Button')) {

    class Gang_Sheet_Button
    {
        public static function init()
        {
            add_action('woocommerce_before_add_to_cart_button',
                [__CLASS__, 'add_custom_button'], 40);
            add_action('wp_head', [__CLASS__, 'add_custom_button_styles']);
            add_action('wp_footer', [
                __CLASS__,
                'add_custom_button_script',
            ]); // Add JS in the footer

        }

        public static function get_contrast_color($hex)
        {
            // Convert hex to RGB
            $r = hexdec(substr($hex, 1, 2));
            $g = hexdec(substr($hex, 3, 2));
            $b = hexdec(substr($hex, 5, 2));

            // Calculate luminance
            $luminance = (0.2126 * $r + 0.7152 * $g + 0.0722 * $b) / 255;

            // Return black or white based on luminance
            return $luminance > 0.5 ? '#000000' : '#FFFFFF';
        }

        public static function add_custom_button(): bool
        {
            global $product, $shop, $config;

            // Check if the global product object exists and is a valid product
            if ($product && wc_get_product($product->get_id())) {
                $productId  = kixxl_wc_generate_resource_id('product', $product->get_id());
                $woo_product_id = $product->get_id();
                // send a custom request to check if the product exists in an external system
                $url= get_site_url() . $config["PROXY_PREFIX"] . '/isRegularProduct/'. $productId;
                $response = wp_remote_get($url,  [
	                'timeout' => 20,
	                'redirection' => 5,
	                'headers' => [
		                'Accept-Encoding' => 'identity',
		                'User-Agent'       => 'Mozilla/5.0 (compatible; MyBot/1.0)',
		                'Cache-Control'    => 'no-cache',
		                'Pragma'           => 'no-cache',
	                ],
                    'sslverify' => false,
                ]);

                // Check for WP_Error
                if (is_wp_error($response)) {
                    // Log the error message for debugging
                    error_log('Error in wp_remote_get: '
                        . $response->get_error_message());

                    return FALSE; // Exit if there is an error in the request
                }

                $status_code = wp_remote_retrieve_response_code($response);
                // Handle 404 Not Found
                if ($status_code == 404) {
                    error_log(json_encode($product->get_id()));
                    error_log('Product not found: 404 error for product ID '
                        . $product->get_id());

                    return FALSE; // Exit if the product is not found
                }

                // Check for successful response (HTTP status code 200)
                if ($status_code == 200) {
                    // Retrieve and log the response data
                    $response_body = wp_remote_retrieve_body($response);
                    $productResponse = json_decode($response_body, true);

                    if (!empty($productResponse) && $productResponse['product_type'] != 'pre_paid') {
                        if ($productResponse['btn_type'] !== 'uploaded') {
                            $backgroundColor = $productResponse['create_button_color'];
                            $textColor = self::get_contrast_color($backgroundColor);

                            echo '<a id="kixxl-custom-button" href="#" data-product-id="' . $productId .
                                '" data-woo-id="' . $woo_product_id . '" data-button-color="' . $backgroundColor . '" 
                            style="background-color:' . $backgroundColor . '; color:' . $textColor . ';">
                            ' . $productResponse['create_button_label'] . '</a>';
                        }

                        if ($productResponse['btn_type'] !== 'created') {
                            $backgroundColor = $productResponse['upload_button_color'];
                            $textColor = self::get_contrast_color($backgroundColor);

                            echo '<a id="kixxl-upload-button" href="#" data-product-id="' . $productId .
                                '" data-woo-id="' . $woo_product_id . '" data-button-color="' . $backgroundColor . '" 
                            style="background-color:' . $backgroundColor . '; color:' . $textColor . ';">
                            ' . $productResponse['upload_button_label'] . '</a>';
                        }

                        echo '<div id="uploader"><kixxl-uploader 
                                v-if="isModalOpen" 
                                @close="closeModal" 
                                :product="'.htmlspecialchars(json_encode($response_body), ENT_QUOTES, 'UTF-8').'" 
                                ></kixxl-uploader></div>';
                    }

                    return TRUE; // Return true if the product exists and the button is displayed
                } else {
                    // Log other HTTP status codes as errors
                    error_log('Error in wp_remote_get: HTTP status code '
                        . $status_code);

                    return FALSE; // Exit if there is an unexpected HTTP status code
                }
            }
            return FALSE; // Return false by default if conditions are not met
        }


        public static function add_custom_button_styles()
        {
            echo '<link href="https://cdnjs.cloudflare.com/ajax/libs/uppy/4.5.0/uppy.min.css" rel="stylesheet" />';
            echo '<link href="https://cdn.jsdelivr.net/npm/file-icon-vectors@1.0.0/dist/file-icon-classic.min.css" rel="stylesheet" />';
            echo '<style>
                .uppy-Dashboard-AddFiles-info{
                        display:block !important;
                    }
                #kixxl-custom-button, #kixxl-upload-button {
                	display: none;
                	width: 300px;
                	background-color: #008558; /* Green background */
                    color: white; /* White text */
                    border: none; /* No border */
                    padding: 15px 32px; /* Padding for button size */
                    text-align: center; /* Center text */
                    text-decoration: none; /* No underline */
                    font-size: 16px; /* Font size */
                    cursor: pointer; /* Pointer cursor on hover */
                    border-radius: 5px; /* Rounded corners */ 
                    margin-bottom: 10px; 
					box-sizing: border-box; /* Ensure padding is included in width */
                }
            
               #kixxl-custom-button:hover, #kixxl-upload-button:hover {
                    background-color: #006946; /* Darker green on hover */
                }
                
                
                </style>';
        }

        public static function add_custom_button_script()
        {
			global $product, $shop, $config;
			
			// Fetch translations from your API
            $translation_url = get_site_url() . $config["PROXY_PREFIX"] . '/get-translations';
            $translation_response = wp_remote_post($translation_url, [
                'method'    => 'POST',
                'headers'   => [
                    'Content-Type' => 'application/json',
                ],
                'sslverify' => false,
                'body'      => json_encode([]),
            ]);
			$translations = [];

			if (!is_wp_error($translation_response)) {
				$body = wp_remote_retrieve_body($translation_response);
				$translations = json_decode($body, true) ?: [];
			}
			
			// Fetch user from your API
            $user_url = get_site_url() . $config["PROXY_PREFIX"] . '/get-user';
            $user_response = wp_remote_post($user_url, [
                'method'    => 'POST',
                'headers'   => [
                    'Content-Type' => 'application/json',
                ],
                'sslverify' => false,
                'body'      => json_encode([]),
            ]);
			$user = [];

			if (!is_wp_error($user_response)) {
				$body = wp_remote_retrieve_body($user_response);
				$user = json_decode($body, true) ?: [];
			}
			
            echo '<script src="https://cdn.jsdelivr.net/npm/uppy@4.5.0/dist/uppy.min.js"></script>';
            echo '<script src="' . esc_url(plugins_url('../js/KixxlUploader.js', __FILE__)) . '" type="module"></script>';
            echo '<script src="' . esc_url(plugins_url('../js/uploader.js', __FILE__)) . '" type="module"></script>';
			
			 // Pass translations as a global JS variable
			echo '<script type="text/javascript">';
			echo 'window.kixxlTranslations = ' . json_encode($translations) . ';';
			echo 'window.kixxlUser = ' . json_encode($user) . ';';
			echo '</script>';

            echo '<script>
                jQuery(document).ready(function($) {
                    $(document).on("show_variation", function(event, variation) {
                    $("#kixxl-custom-button, #kixxl-upload-button").show().css("display","block");
                       
                        if($("#kixxl-custom-button").length || $("#kixxl-upload-button").length)
						{
						   jQuery(".single_add_to_cart_button").hide();
						}
                    });

                    $(document).on("hide_variation", function(event) {
                        $("#kixxl-custom-button").hide();
                    });
                });
                </script>';
        }

    }

    Gang_Sheet_Button::init(); // Initialize the class when the plugin is loaded
}
