import {AwsS3, Dashboard, Uppy} from 'https://releases.transloadit.com/uppy/v4.4.0/uppy.min.mjs';

const translations = window.kixxlTranslations || {};
const User = window.kixxlUser || {};
const accessCartOnlyWhenLogin = User?.permissions?.can_access_add_to_cart_only_when_logged_in;
console.log('can_access_add_to_cart_only_when_logged_in:', accessCartOnlyWhenLogin);

export default {
    template: `<Teleport to="body" >
                  <div id="open-modal" class="gangify-upload-modal" 
                       style="letter-spacing: 0.06rem; position: fixed; top: 0; right: 0; bottom: 0; left: 0; z-index: 999; opacity: 1; pointer-events: all; transition: all 0.3s; font-size: 16px;">
                    <div class="gangify-modal-body" 
                         style="width: 600px; position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 15px; background: white; border-radius: 5px; height: 400px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.5);">
                      <div class="gangify-modal-header" style="font-size: 16px;">
                        <div class="gangify-modal-header-text" 
                             style="font-family: arial; font-weight: 700; font-size: 14px; color: black; text-transform: capitalize;">
                          {{ uploadButtonLabel }}
                        </div>
                        <div class="gangify-modal-header-sub-text" 
                             style="line-height: 3; font-family: arial; font-weight: 400; font-size: 12px; color: #5E7C99; text-transform: capitalize;">
                         {{ getTranslatedText('uploader_modal_header_subtext') }}
                        </div>
                        <div class="gangify-modal-close" @click="close" 
                             style="position: absolute; right: 20px; top: 20px; font-family: inter, sans-serif; color: rgb(128, 128, 128); cursor: pointer;">
                          x
                        </div>
                      </div>
                      <div style="display: flex; flex-direction: column; justify-content: space-between; height: calc(100% - 55px);">
                        <div class="gangify-modal-content" style="flex: 1 1 auto">
                          <div id="uppy-div" v-show="showUppy"></div>
                          <div id="gangify-preview-area" class="gangify-preview-area" v-show="showPreview" 
                               style="font-family: Inter, sans-serif; font-size: 14px; color: #5E7C99; display: flex; flex-direction: column; justify-content: space-between; width: 100%;">
                            <div style="display: flex">
                              <div class="gangify-uploaded-image-div">
                                <div v-html="uploadedSheetIcon" />
                              </div>
                              <div class="meta-data-div" 
                                   style="display: flex; padding: 0px 15px; flex-direction: column; gap: 15px; flex: 1 1 0%; overflow: hidden;">
                                <div class="form-group" 
                                     style="display: flex; flex-direction: column; margin-bottom: 10px;">
                                  <label for="gangify-selected-variant">{{ getTranslatedText('uploader_selected_variant') }}</label>
                                  <select v-model="selectedVariant" @change="handleVariantChange" class="gangify-form-element" 
                                          style="padding: 4px 8px 4px 8px; border-radius: 4px; border: solid thin #DCE1EB; height: 32px; color: #354557;">
                                    <option value="">Select One..</option>
                                    <option :data-width="option.convertedWidth" :data-height="option.convertedHeight" v-for="option in getLoadedProductVariants" :value="option.value">
                                      {{ option.text }}
                                    </option>
                                  </select>
                                </div>
                                <div class="form-row" style="display: flex; gap: 15px; flex: 1 1 auto;">
                                  <div class="form-group" style="flex: 1 1 auto;">
                                    <label for="gangify-uploaded-sheet-dimension">{{ getTranslatedText('uploader_uploaded_sheet_size_label') }}</label>
                                    <input type="text" class="gangify-form-element" :value="getUploadedFileSize" readonly 
                                           style="padding: 4px 8px 4px 8px; border-radius: 4px; border: solid thin #DCE1EB; height: 32px; color: #354557;">
                                  </div>
                                  <div class="form-group" style="max-width: 100px">
                                    <label for="gangify-sheet-quantity">{{ getTranslatedText('uploader_uploaded_sheet_quantity_label') }}</label>
                                    <input type="number" class="gangify-form-element" min="1" max="100" v-model="orderSheetQuantity"
                                           style="padding: 4px 8px 4px 8px; border-radius: 4px; border: solid thin #DCE1EB; height: 32px; color: #354557;">
                                  </div>
                                </div>
                                <div id="kixxl-add-to-cart">
                                  <div id="kixxl-add-to-cart-checkbox-div" v-show="isAddToCartCheckBoxVisible">
                                    <span style="color:red">{{ getTranslatedText('uploader_size_match_error') }}</span>
                                    <div id="kixxl-add-to-cart-checkbox" style="display: flex; align-items: center; justify-content: start;">
                                      <input type="checkbox" v-model="isCheckBoxChecked" id="kixxl-checkbox" style="margin-right: 8px;">
                                      <label for="kixxl-checkbox">{{ getTranslatedText('uploader_agree') }}</label>
                                    </div>
                                  </div>

				                  <div id="kixxl-add-to-cart-user-error-div" v-show="isUserLoginErrorMsgVisible">
									<span style="color:red">{{ getTranslatedText('uploader_user_login_error') }}</span>
								  </div>
                                </div>
                              </div>
                            </div>
                
                            <div id="kixxl-action-row" style="display: flex; gap: 12px; justify-content: end;">
                              <a class="gangify-cancel-upload" href="#" id="gangify-cancel-upload" @click="close"
                                 style="border-radius: 25px; border: solid thin #5E7C99; padding: 5px 15px; text-decoration: none; color: #5E7C99;">
                                {{ getTranslatedText('uploader_cancel_button_label') }}
                              </a>
                              <a href="#" class="kixxl-add-to-cart-btn" id="kixxl-add-to-cart-btn" 
                                 :class="{ active: isAddToCartButtonEnabled, disabled: !isAddToCartButtonEnabled }"
                                 :style="{
                                   pointerEvents: isAddToCartButtonEnabled ? 'auto' : 'none',
                                   opacity: isAddToCartButtonEnabled ? '1' : '0.5'
                                 }" @click.prevent="handleAddToCart"
                                 style="border-radius: 25px; padding: 5px 15px; text-decoration: none; color: white; background: black;">
                                {{ getTranslatedText('uploader_add_to_cart_label') }}
                              </a>
                            </div>
                          </div>
                          <div id="gangify-loading-spinner" v-show="isLoading" class="gangify-loading-spinner"
                               style="display: flex; align-items: center; justify-content: center; border-top: dashed thin gray; margin-top: 15px;">
                            <img src="https://dev2.wysiwyg.bankmarketingcenter.com/animated_loader_gif_n6b5x0.gif">
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </Teleport>`,
    props: {
        product: {
            type: Object,
            required: true,
        },
    },
    data() {
        return {
            isErrorModalVisible: false,
            errorMessage: '',
            isModalOpen: true,
            isAddToCartButtonEnabled: false,
            isAddToCartCheckBoxVisible: false,
            isUserLoginErrorMsgVisible: false,
            isCheckBoxChecked: false,
            uppyObj: null,
            unit: 'cm',
            uploadButtonLabel: 'Upload a Gang Sheet',
            productData: null,
            openModal: false,
            uploadedSheetURL: '',
            uploadedSheetThumbnail: '',
            uploadedSheetIcon: '',
            uploadedFileExtension: '',
            uploadedFileSizeText: '',
            uploadedFileWidth: '',
            uploadedFileHeight: '',
            orderSheetQuantity: 1,
            selectedVariant: null,
            selectedVariantWidth: 0,
            selectedVariantHeight: 0,
            isLoading: false,
            showPreview: false,
            showUppy: true,
            uppyOptions: null,
            uppyDashboardOptions: null,
            uppyAWSOptions: {
                id: 'myAWSPlugin',
                endpoint: 'https://processor.gangifyapp.com/',
                shouldUseMultipart: true,
                getTemporarySecurityCredentials: false,
                getUploadParameters: this.getUploadParameters,
                createMultipartUpload: this.createMultipartUpload,
                abortMultipartUpload: this.abortMultipartUpload,
                signPart: this.signPart,
                listParts: this.listParts,
                completeMultipartUpload: this.completeMultipartUpload,
            }
        };
    },
    methods: {
		 getTranslatedText: function (key) {
//             console.log('returning '.key);
            if (translations && translations[key]) {
                return translations[key];
            }
            return key;
        },
        handleVariantChange: function (event) {
            // Access additional data if needed
            const selectedOption = event.target.selectedOptions[0];
            this.selectedVariantWidth = this.convertToCM(selectedOption.getAttribute("data-width"));
            this.selectedVariantHeight = this.convertToCM(selectedOption.getAttribute("data-height"));
            if (!this.getSelectedOptionValues()) {
                console.log('Error on Selected Variant.........');
            }
        },
        getSelectedOptionValues: function () {
            if (this.selectedVariant) {
                if (((this.uploadedFileWidth <= this.selectedVariantWidth) && (this.uploadedFileHeight <= this.selectedVariantHeight)) || (this.productData.auto_rotate_image && (this.uploadedFileWidth <= this.selectedVariantHeight) && (this.uploadedFileHeight <= this.selectedVariantWidth))) {
                    this.isCheckBoxChecked = true;
                    this.isAddToCartCheckBoxVisible = false;
                    this.isAddToCartButtonEnabled = true;
                } else {
                    this.isCheckBoxChecked = false;
                    this.isAddToCartCheckBoxVisible = true;
                    this.isAddToCartButtonEnabled = false;
                }

                return true;
            } else {
                this.isCheckBoxChecked = false;
                this.isAddToCartButtonEnabled = false;
                return null; // Return null if the element is not found
            }
        },
        close: function () {
            this.$emit('close');
        },

        serializeSubPart: function* (key, value) {
            if (typeof value !== 'object') {
                yield [key, value];
                return;
            }
            if (Array.isArray(value)) {
                for (const val of value) {
                    yield* this.serializeSubPart(`${key}[]`, val);
                }
                return;
            }
            for (const [subkey, val] of Object.entries(value)) {
                yield* this.serializeSubPart(key ? `${key}[${subkey}]` : subkey, val);
            }
        },
        serialize: function (data) {
            return new URLSearchParams(this.serializeSubPart(null, data));
        },
        doneButtonHandler: function (ev) {
            ev.preventDefault();
            this.showUppy = false;
            this.isLoading = true;
            this.uploadedSheetURL = this.uppyObj.getFiles()[0]['uploadURL'];
            this.uploadedSheetThumbnail = this.uppyObj.getFiles()[0]['preview'];
            this.uploadedFileExtension = this.uppyObj.getFiles()[0]['extension'];
            this.uploadedSheetIcon = `<span class="fiv-cla fiv-icon-${this.uploadedFileExtension}" style="font-size: 160px"></span>`;
            const formData = new FormData();
            formData.append('image', this.uploadedSheetURL);
            fetch('https://processor.gangifyapp.com/api/getGangsheetDimensions', {
                method: 'POST',
                body: formData
            })
                .then(response => {
                    if (!response.ok) throw new Error('Something went wrong.');
                    return response.json();
                })
                .then(data => {
                    this.uploadedFileWidth = data.width;
                    this.uploadedFileHeight = data.height;
                    this.isLoading = false;
                    this.showPreview = true;
                    this.uploadedSheetURL = data.gangSheet;

                    try {
                        const variant = this.getSelectedVariant();
                        if (variant && variant.id) {
                            const variantId = variant.id;

                            const loadedProductVariants=this.productData.variants;

                            const selectedVariant = loadedProductVariants.find(variant => Number(variant.id) === Number(variantId));
                            this.selectedVariant = selectedVariant.id;
                            this.selectedVariantWidth = selectedVariant.width;
                            this.selectedVariantHeight = selectedVariant.height;
                        }
                    } catch (error) {
                        console.error("An error occurred while getting the selected variant:", error);
                    }


                    if (!this.getSelectedOptionValues()) {
                        console.log('Error on Selected Variant.........');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    this.showErrorModal('Unable to upload the file at this time. Please try again later.');
                    this.isLoading = false;
                    this.showUppy = true;
                });
        },
        getUploadParameters: async function (file, options) {
            if (typeof crypto?.subtle === 'object') {
                // If WebCrypto is available, let's do signing from the client.
                return uppyObj
                    .getPlugin('myAWSPlugin')
                    .createSignedURL(file, options);
            }
            const response = await fetch('/s3/sign', {
                method: 'POST',
                headers: {
                    accept: 'application/json',
                },
                body: this.serialize({
                    filename: file.name,
                    contentType: file.type,
                }),
                signal: options.signal,
            });

            if (!response.ok) {
                throw new Error('Unsuccessful request', {cause: response});
            }

            // Parse the JSON response.
            const data = await response.json();

            // Return an object in the correct shape.
            return {
                method: data.method,
                url: data.url,
                fields: {},
                headers: {
                    'Content-Type': file.type,
                },
            };
        },
        createMultipartUpload: async function (file, signal) {
            signal?.throwIfAborted();

            const metadata = {};

            Object.keys(file.meta || {})
                .forEach((key) => {
                    if (file.meta[key] != null) {
                        metadata[key] = file.meta[key].toString();
                    }
                });

            const response = await fetch('https://processor.gangifyapp.com/s3/multipart', {
                method: 'POST',
                // Send and receive JSON.
                headers: {
                    accept: 'application/json',
                },
                body: this.serialize({
                    filename: file.name,
                    type: file.type,
                    metadata,
                }),
                signal,
            });

            if (!response.ok) {
                throw new Error('Unsuccessful request', {cause: response});
            }

            // Parse the JSON response.
            const data = await response.json();

            return data;
        },
        abortMultipartUpload: async function (file, {key, uploadId, signal}) {
            const filename = encodeURIComponent(key);
            const uploadIdEnc = encodeURIComponent(uploadId);
            const response = await fetch(
                `https://processor.gangifyapp.com/s3/multipart/${uploadIdEnc}?key=${filename}`,
                {
                    method: 'DELETE',
                    signal,
                },
            );

            if (!response.ok) {
                throw new Error('Unsuccessful request', {cause: response});
            }
        },
        signPart: async function (file, options) {
            const {uploadId, key, partNumber, signal} = options;

            signal?.throwIfAborted();

            if (uploadId == null || key == null || partNumber == null) {
                throw new Error(
                    'Cannot sign without a key, an uploadId, and a partNumber',
                );
            }

            const filename = key;
            const response = await fetch(
                `https://processor.gangifyapp.com/s3/multipart/${uploadId}/${partNumber}?key=${filename}`,
                {signal},
            );

            if (!response.ok) {
                throw new Error('Unsuccessful request', {cause: response});
            }

            const data = await response.json();

            return data;
        },
        listParts: async function (file, {key, uploadId}, signal) {
            signal?.throwIfAborted();

            const filename = key;
            const response = await fetch(
                `https://processor.gangifyapp.com/s3/multipart/${uploadId}?key=${filename}`,
                {signal},
            );

            if (!response.ok) {
                throw new Error('Unsuccessful request', {cause: response});
            }

            const data = await response.json();

            return data;
        },
        completeMultipartUpload: async function (file, {key, uploadId, parts}, signal,) {
            signal?.throwIfAborted();
            let partsArray = [];
            let formData = new FormData();
            parts.forEach((item, index) => {
                formData.append(`parts[${index}][ETag]`, item.ETag);
                formData.append(`parts[${index}][PartNumber]`, item.PartNumber);

            });
            formData.append(`folder`, 'temp');
            const filename = key;
            const uploadIdEnc = encodeURIComponent(uploadId);
            parts = partsArray;
            const response = await fetch(
                `https://processor.gangifyapp.com/s3/multipart/${uploadIdEnc}/complete?key=${filename}`,
                {
                    method: 'POST',
                    headers: {
                        accept: 'application/json',
                    },
                    body: formData,
                    signal,
                },
            );

            if (!response.ok) {
                throw new Error('Unsuccessful request', {cause: response});
            }

            const data = await response.json();

            return data;
        },
        convertToCM: function (value) {
            if (this.unit === 'inches') {                // Convert to inches
                return (value * 2.54).toFixed(2);
            } else if (this.unit === 'mm') {
                return (value / 10).toFixed(2);
            }
            return value;
        },
        getConvertedValue: function (value) {
            if (this.unit === 'inches') {
                return (value * 0.393701).toFixed(2);
            } else if (this.unit === 'mm') {
                return (value * 10).toFixed(2);

            }
            return value;
        },
        getSelectedVariant: function () {
            let variants = this.productData.variants;
            let variantID = getVariantId() ? getVariantId() : '';
            let variant = variants.find((v) => v.id == this.kixxl_wc_generate_resource_id(variantID))
            if (variant) {
                return variant
            }
        },
        kixxl_wc_generate_resource_id: function (resource_id) {
            let shop_id = this.productData.shop.id.toString().padStart(4, '0');
            // Return the formatted Resource ID
            return `4403${shop_id}${resource_id}`;
        },

        // Uploader
        handleAddToCart: async function () {
			
			if(accessCartOnlyWhenLogin && (!php_vars.current_user || !php_vars.current_user?.ID) ) {
				this.isUserLoginErrorMsgVisible = true;
				return;
			}
			
            if (!this.isCheckBoxChecked && !this.isAddToCartButtonEnabled) {
                return;
            }

            let uploadedGangSheet = this.uploadedSheetURL;

            const parsedUrl = new URL(uploadedGangSheet);
            // Remove the leading slash if it exists
            uploadedGangSheet = parsedUrl.pathname.startsWith('/')
                ? parsedUrl.pathname.slice(1) + parsedUrl.hash
                : parsedUrl.pathname + parsedUrl.hash;

            let appUrl = php_vars.config.APP_URL;

            let sheetKey = Math.floor(Math.random() * 9999999999999);

            const selectedVariant = this.selectedVariant;
            const quantity = this.orderSheetQuantity

            const yayExtraOptions = this.collectYayExtraOptions();

            const baseProperties = {
                '_app_name': 'Kixxl',
                '_actual_gang_sheet': `${appUrl}/preview-sheet/${sheetKey}#/uploads/preview-sheet`,
                'sheet_preview': `${appUrl}/preview/${uploadedGangSheet}#/uploads/gang-sheet`,
                'sheet_type': 'uploaded'
            };

            // Merge YayExtra options dynamically
            const allProperties = { ...baseProperties, ...yayExtraOptions };

            const formData = {
                'items': [
                    {
                        'id': selectedVariant, // Product variant ID
                        'quantity': quantity, // Quantity to add
                        'price': this.productData.price,
                        'properties': allProperties
                    }
                ]
            };

            var shop=this.productData.shop.name;

            let apiUrl = `https://${shop}/?rest_route=/kwc/v1/kixxl_wc_temp_cart_store&store=${shop}`;

            const filePath = await fetch(apiUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(formData)
            });

            const data = await filePath.json();

            if(data.error === false)
            {
                let url = `https://${shop}/?add-to-cart-multiple=true`;
                url += '&file='+data.file;

                // Handle the data for the last item
                window.onbeforeunload = null;
                if (window.top === window.self) {
                    // Not in an iframe, perform a normal redirect
                    window.location.href = url;
                } else {
                    // In an iframe, perform a redirect in the parent window
                    window.top.location.href = url;
                }
            }
        },
        showErrorModal: function (message) {
            this.errorMessage = message;
            this.showErrorModal = true;
        },
        closeErrorModal: function () {
            this.showErrorModal = false;
        },
        closeModal: function () {
            this.isModalOpen = false;
        },
        openModal: function (e) {
            this.isModalOpen = false;
        },

        updateAllowedFileTypes: function (newTypes) {
            let allowedFileTypesArray = newTypes
                .filter(file => file.allowed)
                .map(file => `'.${file.title.toLowerCase()}'`)
                .join(',');
            return allowedFileTypesArray.replace(/'/g, '').split(',');
        },
        collectYayExtraOptions() {
            const optionSelector = 'input[name^="option_field_data["]:not(:disabled), select[name^="option_field_data["]:not(:disabled), textarea[name^="option_field_data["]:not(:disabled)';
            const fields = jQuery(optionSelector);
            const options = {};

            fields.each(function () {
                const el = jQuery(this);
                const fieldWrap = el.closest('.yayextra-option-field-wrap');
                let displayName = fieldWrap.find('.yayextra-option-field-name span').text().trim();

                if (!displayName) return;
                displayName = "extra_" + displayName;

                // Handle checkbox groups — collect all checked ones under the same name
                if (el.is(':checkbox')) {
                    if (el.is(':checked')) {
                        const val = el.val();
                        if (options[displayName]) {
                            options[displayName] += '+ ' + val;
                        } else {
                            options[displayName] = val;
                        }
                    }
                }
                // Handle radio buttons — only checked one counts
                else if (el.is(':radio')) {
                    if (el.is(':checked')) {
                        options[displayName] = el.val();
        }
                }
                // Handle selects and text inputs
                else {
                    const val = el.val();
                    if (Array.isArray(val)) {
                        options[displayName] = val.join('+ ');
                    } else {
                        options[displayName] = val !== undefined ? val : '';
                    }
                }
            });

            // Final cleanup (remove empty values)
            Object.keys(options).forEach((key) => {
                if (!options[key] || options[key].toString().trim() === '') {
                    delete options[key];
                }
            });

            return options;
        },
    },
    mounted() {
        const quantityInput = document.querySelector("input[name='quantity']");
        this.orderSheetQuantity = parseInt(quantityInput?.value) || 1;

        this.productData = JSON.parse(this.product)
        this.unit = this.productData.shop.setting.unit_measure;
        this.uploadButtonLabel = this.productData.upload_button_label;

        const allowedFileTypes = this.updateAllowedFileTypes(JSON.parse(this.productData.file_types));
        const allowedFileTypesText = `${this.getTranslatedText('uploader_allowed_file_type_text')}: ${allowedFileTypes.map(type => type.replace('.', '').toUpperCase()).join(", ")}. ${this.getTranslatedText('uploader_allowed_size_label')} 2 GB`;
        this.uppyOptions = {
            restrictions: {
                maxFileSize: 2000000000,
                maxNumberOfFiles: 1,
                minNumberOfFiles: 1,
                allowedFileTypes: allowedFileTypes,
            },
            autoProceed: true,
        };
        this.uppyDashboardOptions = {
            inline: true,
            width: '100%',
            height: 325,
            target: '#uppy-div',
            note: allowedFileTypesText,
            proudlyDisplayPoweredByUppy: false,
            doneButtonHandler: this.doneButtonHandler,
			locale: {
					strings:{
					  dropPasteFiles: this.getTranslatedText('uploader_drop_file_label') + ' %{browseFiles}',
					  browseFiles:    this.getTranslatedText('uploader_browse_file_label'),
					  uploadComplete: this.getTranslatedText('uploader_upload_complete_label'),
					  uploadingXFiles:{
						0: `${this.getTranslatedText('uploader_uploading_text')} %{smart_count} file`,
						1: `${this.getTranslatedText('uploader_uploading_text')} %{smart_count} files`,
					  },
					  uploadPaused:   this.getTranslatedText('uploader_upload_pause_label'),
					  retryUpload:    this.getTranslatedText('uploader_upload_retry_label'),
					  cancelUpload:   this.getTranslatedText('uploader_upload_cancel_label'),
					  dropHint:       this.getTranslatedText('uploader_drop_hint'),
					  uploading:      this.getTranslatedText('uploader_uploading_text'),
					  xTimeLeft:      this.getTranslatedText('uploader_time_left_text'),
					  complete:       this.getTranslatedText('uploader_complete_text'),
					  done:           this.getTranslatedText('uploader_done_button_label'),


					}
			},
        };

        this.uppyObj = new Uppy(this.uppyOptions)
            .use(Dashboard, this.uppyDashboardOptions)
            .use(AwsS3, this.uppyAWSOptions);
    },
    computed: {
        getLoadedProductVariants() {
            let variantList = [];
            const productData = JSON.parse(this.product);
            try {
                this.loadedProductVariants = productData.variants;
                if (this.loadedProductVariants && Array.isArray(this.loadedProductVariants)) {
                    this.loadedProductVariants.forEach(variant => {
                        variantList.push({
                            text: variant.title,
                            value: variant.id,
                            convertedWidth: this.getConvertedValue(variant.width),
                            convertedHeight: this.getConvertedValue(variant.height)
                        });
                    });
                }
            } catch (error) {
                console.error('Invalid product JSON:', error);
            }

            // Fallback for products without variants
            if (variantList.length === 0) {
                variantList.push({
                    text: productData.title,
                    value: productData.id,
                    convertedWidth: this.getConvertedValue(productData.width),
                    convertedHeight: this.getConvertedValue(productData.height)
                });
            }

            // Automatically set the first option as selected
            if (variantList.length > 0 && !this.selectedVariant) {
                this.selectedVariant = variantList[0].value;
                this.selectedVariantWidth = variantList[0].convertedWidth;
                this.selectedVariantHeight = variantList[0].convertedHeight;
            }

            return variantList;
        },
        getUploadedFileSize() {
            return this.getConvertedWidth + ' x ' + this.getConvertedHeight + ' ' + this.unit;
        },
        getConvertedWidth() {
            return this.getConvertedValue(this.uploadedFileWidth);
        },
        getConvertedHeight() {
            return this.getConvertedValue(this.uploadedFileHeight);
        }
    },
    watch: {
        isCheckBoxChecked(value) {
            if (value) {
                this.isAddToCartButtonEnabled = true;
            } else {
                this.isAddToCartButtonEnabled = false;
            }
        },
    }
};
