window.getVariantId = function () {
    const variantInput = document.querySelector('input[name="variation_id"]');
    return variantInput && variantInput.value != 0 ? variantInput.value : 0;
};
jQuery(document).ready(function ($) {
    let variantExists = true;
    if (!$('input[name="variation_id"]').length) {
        $("#kixxl-custom-button, #kixxl-upload-button").show().css("display","block");

        if($("#kixxl-custom-button").length || $("#kixxl-upload-button").length)
        {
            jQuery(".single_add_to_cart_button").hide();
        }

        variantExists = false;
    }

    // Function to get the price
    function getPrice() {
        var priceText = $('.woocommerce-Price-amount').eq(1).text();
        // Remove symbols using a regular expression
        return parseFloat(priceText.replace(/[^0-9.]/g, ''));
    }
    function getProductId() {
        return $('input[name="product_id"]').val();
    }

    // Handle button click
    $('#kixxl-custom-button').on('click', function (e) {
        e.preventDefault(); // Prevent the default action

        // Get values
        let variantId = getVariantId() ? getVariantId() : '';
        //this is woocommerce product id
        let wp = $(this).data('woo-id');
        // Get the data-product-id attribute value
        let productId = $(this).data('product-id');
        // Check if any value is empty
        if ((variantExists && !variantId) || !productId) {
            alert('Error: Please ensure that you are selected any variant.');
            return; // Do not proceed further
        }

        var quantityInput = document.querySelector("input[name='quantity']");
        let kixxlProductQuantity = parseInt(quantityInput?.value) ?? 1;

        let customerId = php_vars.customer_id ? encodeURIComponent(php_vars.customer_id) : '';

        customerId = customerId == 0 ? '' : customerId;

        const yayExtraOptions = collectYayExtraOptions();
        // Convert YayExtra options to JSON and encode it for URL
        const yayExtraEncoded = encodeURIComponent(JSON.stringify(yayExtraOptions));
        let customLink = window.location.origin +
            `/?rest_route=/kwc/v1/editor` +
            `&variant=${encodeURIComponent(variantId)}` +
            `&store=${encodeURIComponent(php_vars.shop)}` +
            `&product=${encodeURIComponent(productId)}` +
            `&quantity=${encodeURIComponent(kixxlProductQuantity)}` +
            `&customer=${customerId}` +
            `&wp=${encodeURIComponent(wp)}`+`&extra=${yayExtraEncoded}`;

        if (php_vars.config.APP_ENV == 'local') {
            customLink = 'https://localhost/wordpress' +
                `/?rest_route=/kwc/v1/editor` +
                `&variant=${encodeURIComponent(variantId)}` +
                `&product=${encodeURIComponent(productId)}` +
                `&quantity=${encodeURIComponent(kixxlProductQuantity)}` +
                `&customer=${customerId}` +
                `&wp=${encodeURIComponent(wp)}` +
                `&extra=${yayExtraEncoded}` +
                '&local=true';
        }
        // Open the link in a new tab
        window.open(customLink, "_self");
    });

    function URLify(string) {
        const urls = string.match(/((((ftp|https?):\/\/)|(w{3}\.))[\-\w@:%_\+.~#?,&\/\/=]+)/g);
        if (urls) {
            urls.forEach(function (url) {
                string = string.replace(url, '<a target="_blank" href="' + url + '">' + "Preview" + "</a>");
            });
        }
        return string.replace("(", "<br/>(");
    }

    function waitForElm(selector) {
        return new Promise(resolve => {
            if (document.querySelector(selector)) {
                return resolve(document.querySelector(selector));
            }

            const observer = new MutationObserver(mutations => {
                if (document.querySelector(selector)) {
                    observer.disconnect();
                    resolve(document.querySelector(selector));
                }
            });

            observer.observe(document.body, {
                childList: true,
                subtree: true
            });
        });
    }

    waitForElm('.wc-block-components-product-details__value').then((elm) => {
        var previewLinks = document.getElementsByClassName("wc-block-components-product-details__value");
        //Update links in metafields
        for (previewLink of previewLinks) {
            previewLink.innerHTML = URLify(previewLink.innerText);
        }
    });

    waitForElm('.variation-sheet_preview').then((elm) => {
        var previewLinks = document.getElementsByClassName("variation-sheet_preview");
        //Update links in metafields
        for (previewLink of previewLinks) {
            previewLink.innerHTML = URLify(previewLink.innerText);

        }
    });
    var previewLinks = document.getElementsByClassName("wc-block-components-product-details__value");
    //Update links in metafields
    for (previewLink of previewLinks) {
        previewLink.innerHTML = URLify(previewLink.innerText);
    }

    // Collect all YayExtra options (supporting text/select/textarea/radio/checkbox/multiple)
    function collectYayExtraOptions() {
        const optionSelector = 'input[name^="option_field_data["]:not(:disabled), select[name^="option_field_data["]:not(:disabled), textarea[name^="option_field_data["]:not(:disabled)';
        const fields = $(optionSelector);
        const options = {};

        fields.each(function () {
            const el = $(this);
            const fieldWrap = el.closest('.yayextra-option-field-wrap');
            let displayName = fieldWrap.find('.yayextra-option-field-name span').text().trim();

            if (!displayName) return; // skip if no label found
            displayName = "extra_" + displayName;

            // Handle checkbox groups — collect all checked ones under the same name
            if (el.is(':checkbox')) {
                if (el.is(':checked')) {
                    const val = el.val();
                    if (options[displayName]) {
                        options[displayName] += '+ ' + val;
                    } else {
                        options[displayName] = val;
                    }
                }
            }
            // Handle radio buttons — only checked one counts
            else if (el.is(':radio')) {
                if (el.is(':checked')) {
                    options[displayName] = el.val();
                }
            }
            // Handle selects and text inputs
            else {
                const val = el.val();
                if (Array.isArray(val)) {
                    options[displayName] = val.join('+ ');
                } else {
                    options[displayName] = val !== undefined ? val : '';
                }
            }
        });

        // Final cleanup (remove empty values)
        Object.keys(options).forEach((key) => {
            if (!options[key] || options[key].toString().trim() === '') {
                delete options[key];
            }
        });

        return options;
    }

});